/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.websm.updates;

import com.ibm.hsc.auiml.databeans.ucode.APIDownloadError;
import com.ibm.hsc.auiml.databeans.ucode.IOSurveyResultsAPI;
import com.ibm.hsc.auiml.databeans.ucode.RepositoryItem;
import com.ibm.hsc.auiml.databeans.ucode.ResourceItem;
import com.ibm.hsc.auiml.databeans.ucode.ResourceList;
import com.ibm.hsc.websm.updates.PIUpdateErrorIds;
import com.ibm.hsc.websm.updates.PIUpdateException;
import com.ibm.hsc.websm.updates.PIUpdateableComponent;
import com.ibm.hsc.websm.updates.PIUpdatesOwner;
import com.ibm.hwmca.base.updates.UpdateUtilities;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.util.Trace;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class SurveyAndImportHandler
implements PIUpdateErrorIds {
    private static final String TRACE_MASKT = "XUPDIOHT";
    private static final String TRACE_MASKF = "XUPDIOHF";
    private static final String TRACE_MASKD = "XUPDIOHD";
    private static SurveyAndImportHandler handler = new SurveyAndImportHandler();
    private boolean applyDone;
    private IOSurveyResultsAPI api;
    private HException applyException;
    private ResourceList entireIOSurvey;
    private ArrayList importIOList;
    private ArrayList importIOResults;
    private RepositoryItem lastRepository;
    private List ownerList;
    private ArrayList targetList;
    private boolean surveyDone;
    private List rpmsToImportFromWebsite;
    private int stagingAreaInUse;
    private ArrayList websiteSurvey;
    private boolean websiteSurveyDone;

    public static SurveyAndImportHandler getSurveyAndImportHandler() {
        return handler;
    }

    private SurveyAndImportHandler() {
        Trace.trace((String)TRACE_MASKT, (Object)"<> SurveyAndImportHandler()");
        this.targetList = new ArrayList();
        this.ownerList = new ArrayList();
        this.surveyDone = false;
        this.websiteSurveyDone = false;
        this.importIOList = null;
        this.applyDone = false;
        try {
            this.api = new IOSurveyResultsAPI();
        }
        catch (HException hException) {
            Trace.trace((String)TRACE_MASKF, (Object)("IOSurveyresultsAPI returned " + (Object)((Object)hException)));
        }
    }

    public void addTarget(String string, String string2, PIUpdatesOwner pIUpdatesOwner) {
        ResourceItem resourceItem;
        Trace.trace((String)TRACE_MASKT, (Object)("<> addTarget(" + string + ")"));
        ListIterator listIterator = this.targetList.listIterator();
        boolean bl = false;
        while (listIterator.hasNext()) {
            resourceItem = (ResourceItem)listIterator.next();
            if (!string.equals(resourceItem.getMTMS())) continue;
            bl = true;
            Trace.trace((String)TRACE_MASKF, (Object)("Target with MTMS " + string + " is already in the list."));
        }
        if (!bl) {
            resourceItem = new ResourceItem(" ", 4, string, string2);
            this.targetList.add(resourceItem);
            this.ownerList.add(pIUpdatesOwner);
        }
        this.surveyDone = false;
        this.websiteSurveyDone = false;
    }

    public void applyIOMicrocode(String string) throws HException {
        Trace.trace((String)TRACE_MASKT, (Object)"-> applyIOMicrocode()");
        if (this.entireIOSurvey != null) {
            if (!this.applyDone) {
                this.surveyDone = false;
                ArrayList<ResourceItem> arrayList = new ArrayList<ResourceItem>();
                ArrayList arrayList2 = this.entireIOSurvey.getResourceList();
                ListIterator listIterator = arrayList2.listIterator();
                while (listIterator.hasNext()) {
                    ResourceItem resourceItem = (ResourceItem)listIterator.next();
                    if (!resourceItem.getChecked()) continue;
                    arrayList.add(resourceItem);
                    Trace.trace((String)TRACE_MASKF, (Object)("Resource item [" + resourceItem.getRPMFILE() + "] was selected."));
                }
                Trace.trace((String)TRACE_MASKF, (Object)("selectedItems.size()=" + arrayList.size()));
                if (arrayList.size() != 0) {
                    try {
                        this.api.applyIOMicrocode(arrayList);
                        this.applyException = null;
                    }
                    catch (HException hException) {
                        this.applyException = hException;
                    }
                }
                this.applyDone = true;
            }
            if (this.applyException != null) {
                Trace.trace((String)TRACE_MASKF, (Object)("Throwing exceptoin " + (Object)((Object)this.applyException)));
                throw this.applyException;
            }
        } else {
            Trace.trace((String)TRACE_MASKF, (Object)"The survey of I/O microcode returned a null.");
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- applyIOMicrocode()");
    }

    public ResourceList getEntireIOSurvey() {
        Trace.trace((String)TRACE_MASKT, (Object)"<> getEntireIOSurvey()");
        return this.entireIOSurvey;
    }

    public void setEntireIOSurvey(ResourceList resourceList) {
        Trace.trace((String)TRACE_MASKT, (Object)"<> setEntireIOSurvey()");
        Trace.trace((String)TRACE_MASKD, (Object)("setEntireIOSurvey resList: " + resourceList));
        this.entireIOSurvey = resourceList;
    }

    public String importFromWebsite(String string, ArrayList arrayList, String string2) throws HException {
        String string3;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Trace.trace((String)TRACE_MASKT, (Object)"-> importFromWebsite");
        String string4 = null;
        ArrayList<Object> arrayList2 = new ArrayList<Object>(arrayList);
        ListIterator listIterator = arrayList.listIterator();
        while (listIterator.hasNext()) {
            object4 = (String)listIterator.next();
            object3 = ((String)object4).substring(0, 7);
            object2 = (String)object3 + "." + "xml";
            Trace.trace((String)TRACE_MASKD, (Object)("Adding [" + (String)object2 + "] to the list."));
            arrayList2.add(object2);
        }
        object4 = new RepositoryItem(0);
        object3 = this.api.downloadFixpack((RepositoryItem)object4, arrayList2, string2);
        object2 = ((ArrayList)object3).listIterator();
        while (object2.hasNext()) {
            object = (APIDownloadError)object2.next();
            if (0 == ((APIDownloadError)object).getReturnCode()) continue;
            string3 = ((APIDownloadError)object).getReturnMessage();
            Trace.trace((String)TRACE_MASKD, (Object)("Message [" + string3 + "] added to the list."));
            if (string4 == null) {
                string4 = string3;
                continue;
            }
            string4 = string4 + " " + string3;
        }
        if (string4 == null) {
            listIterator = arrayList.listIterator();
            while (listIterator.hasNext()) {
                object = (String)listIterator.next();
                string3 = ((String)object).substring(0, 7);
                String string5 = string2 + string3 + "." + "xml";
                int n = ((String)object).lastIndexOf(".");
                String string6 = string2 + ((String)object).substring(0, n + 1) + "xml";
                try {
                    UpdateUtilities.copyFile((String)string5, (String)string6);
                }
                catch (IOException iOException) {
                    Trace.trace((String)TRACE_MASKF, (Object)("Import of cover letter from website failed " + iOException));
                    PIUpdateException pIUpdateException = new PIUpdateException(-1806, iOException);
                    throw pIUpdateException;
                }
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- importFromWebsite()");
        return string4;
    }

    public List importIOMicrocode(String string) throws HException {
        Trace.trace((String)TRACE_MASKT, (Object)"-> importIOMicrocode()");
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.entireIOSurvey != null) {
            Serializable serializable;
            Object object;
            Object object2;
            Object object3;
            if (this.importIOList != null) {
                object3 = new ArrayList();
                object2 = this.entireIOSurvey.getResourceList();
                object = object2.listIterator();
                while (object.hasNext()) {
                    serializable = (ResourceItem)object.next();
                    if (!((ResourceItem)serializable).getChecked()) continue;
                    ((ArrayList)object3).add(((ResourceItem)serializable).getRPMFILE());
                    Trace.trace((String)TRACE_MASKF, (Object)("Resource item [" + ((ResourceItem)serializable).getRPMFILE() + "] was selected."));
                }
                this.importIOResults = this.api.downloadFixpack(this.lastRepository, (ArrayList)object3);
                this.importIOList = object3;
                this.applyDone = false;
            }
            object3 = this.importIOResults.listIterator();
            while (object3.hasNext()) {
                object2 = (APIDownloadError)object3.next();
                if (0 == ((APIDownloadError)object2).getReturnCode()) continue;
                object = ((APIDownloadError)object2).getFileName();
                Trace.trace((String)TRACE_MASKD, (Object)("Is [" + (String)object + "] applicable to mtms [" + string + "]?"));
                serializable = this.entireIOSurvey.getResourceList(string);
                ListIterator listIterator = serializable.listIterator();
                while (listIterator.hasNext()) {
                    ResourceItem resourceItem = (ResourceItem)listIterator.next();
                    String string2 = resourceItem.getRPMFILE();
                    Trace.trace((String)TRACE_MASKD, (Object)("Checking [" + string2 + "]."));
                    if (!((String)object).equalsIgnoreCase(string2)) continue;
                    arrayList.add(((APIDownloadError)object2).getReturnMessage());
                    Trace.trace((String)TRACE_MASKD, (Object)("Message [" + ((APIDownloadError)object2).getReturnMessage() + "] added to the list."));
                }
            }
        } else {
            Trace.trace((String)TRACE_MASKF, (Object)"The survey of I/O microcode returned a null.");
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- importIOMicrocode()");
        return arrayList;
    }

    public boolean isStagingAreaInUse() {
        boolean bl = true;
        if (this.stagingAreaInUse == 0) {
            bl = false;
        }
        Trace.trace((String)TRACE_MASKT, (Object)("<> isStagingAreaInUse returns " + (bl ? "true" : "false")));
        return bl;
    }

    public void setStagingAreaInUse(boolean bl) {
        this.stagingAreaInUse = bl ? ++this.stagingAreaInUse : --this.stagingAreaInUse;
        Trace.trace((String)TRACE_MASKT, (Object)("<> setStagingAreaInUse users=" + this.stagingAreaInUse));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List surveyIOMicrocode(RepositoryItem repositoryItem, String string) throws HException {
        Trace.trace((String)TRACE_MASKT, (Object)"-> surveyIOMicrocode()");
        if (this.surveyDone && this.lastRepository.getReposType() != repositoryItem.getReposType()) {
            this.surveyDone = false;
        }
        Object object = this;
        synchronized (object) {
            if (!this.surveyDone || this.entireIOSurvey == null) {
                try {
                    this.entireIOSurvey = this.api.startSurvey(repositoryItem, this.targetList);
                    this.applyDone = false;
                    this.lastRepository = repositoryItem;
                    this.importIOList = null;
                }
                catch (Exception exception) {
                    this.entireIOSurvey = null;
                    Trace.trace((String)TRACE_MASKF, (Object)("Ignoring I/O microcode survey exception " + exception));
                }
            }
        }
        object = new ArrayList();
        if (this.entireIOSurvey != null) {
            object = this.entireIOSurvey.getResourceList(string);
        } else {
            Trace.trace((String)TRACE_MASKF, (Object)"The survey of I/O microcode returned a null.");
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- surveyIOMicrocode()");
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List surveyRemoteSite(RepositoryItem repositoryItem) throws HException {
        Trace.trace((String)TRACE_MASKT, (Object)"-> surveyRemoteSite()");
        Object object = this;
        synchronized (object) {
            this.websiteSurveyDone = false;
            if (!this.websiteSurveyDone) {
                Object object2;
                Object object3;
                Object object4;
                String[] stringArray;
                ArrayList<Object> arrayList = new ArrayList<Object>();
                String string = null;
                ListIterator listIterator = this.ownerList.listIterator();
                while (listIterator.hasNext()) {
                    stringArray = (String[])listIterator.next();
                    object4 = stringArray.getUpdateableComponents(false);
                    ListIterator listIterator2 = object4.listIterator();
                    while (listIterator2.hasNext()) {
                        object3 = (PIUpdateableComponent)listIterator2.next();
                        object2 = ((PIUpdateableComponent)object3).getECNumber();
                        Trace.trace((String)TRACE_MASKD, (Object)("Adding EC number [" + (String)object2 + "]"));
                        arrayList.add(object2);
                    }
                    if (listIterator.hasNext()) continue;
                    string = stringArray.getDataArea();
                }
                try {
                    Trace.trace((String)TRACE_MASKD, (Object)"Converting list to string array.");
                    stringArray = new String[arrayList.size()];
                    object4 = arrayList.listIterator();
                    int n = 0;
                    while (object4.hasNext()) {
                        stringArray[n] = (String)object4.next();
                        ++n;
                    }
                    object3 = this.api.getFixpackNames(repositoryItem, stringArray, string);
                    this.websiteSurvey = new ArrayList();
                    object2 = ((ArrayList)object3).listIterator();
                    while (object2.hasNext()) {
                        Object object5;
                        Object object6;
                        Object object7;
                        Object e = object2.next();
                        if (e instanceof APIDownloadError) {
                            object7 = (APIDownloadError)e;
                            object6 = ((APIDownloadError)object7).getReturnMessage();
                            object5 = new PIUpdateException(-1808, (String)object6);
                            throw object5;
                        }
                        object7 = (ArrayList)e;
                        object6 = ((ArrayList)object7).iterator();
                        while (object6.hasNext()) {
                            object5 = (String)object6.next();
                            Trace.trace((String)TRACE_MASKD, (Object)("Adding RPM [" + (String)object5 + "] to list."));
                            this.websiteSurvey.add((String)object5 + ".rpm");
                        }
                    }
                    this.websiteSurveyDone = true;
                }
                catch (Throwable throwable) {
                    this.websiteSurvey = new ArrayList();
                    object4 = new PIUpdateException(-1807, throwable);
                    throw object4;
                }
            }
        }
        object = new ArrayList();
        object = this.websiteSurvey;
        Trace.trace((String)TRACE_MASKT, (Object)"<- surveyRemoteSite()");
        return object;
    }
}

